package ru.yandex.chemodan.app.smartcache.worker.actions;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.web.convert.ConvertToDataapiUser;
import ru.yandex.chemodan.app.smartcache.NS;
import ru.yandex.chemodan.app.smartcache.worker.processing.PhotosliceProcessingManager;
import ru.yandex.chemodan.util.web.OkPojo;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.a3.action.support.PublicCloneableActionSupport;

/**
 * @author osidorkin
 */
@Action(
        value = @Action.Alias(value = "update-shapshot", namespace = NS.SMARTCACHE),
        description = "Обновить снапшот в базе, если он есть")
@Path(value = "/smartcache-update-snapshot", methods = {HttpMethod.GET, HttpMethod.POST})
public class PhotosliceUpdateNotificationAction extends PublicCloneableActionSupport {

    private static final OkPojo OK_POJO = new OkPojo();

    @RequestParam(value = "__uid", customConverter = ConvertToDataapiUser.class)
    private DataApiUserId user;
    @RequestParam
    private Option<Long> timestamp;

    private final PhotosliceProcessingManager photosliceProcessingManager;

    public PhotosliceUpdateNotificationAction(PhotosliceProcessingManager photosliceProcessingManager) {
        this.photosliceProcessingManager = photosliceProcessingManager;
    }

    @Override
    public OkPojo execute() throws Exception {
        photosliceProcessingManager.handleSnapshotUpdate(user, timestamp.map(Instant::new));
        return OK_POJO;
    }

}
