package ru.yandex.chemodan.app.smartcache.worker.actions;

import org.joda.time.Duration;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.smartcache.worker.processing.PhotosliceProcessingManager;
import ru.yandex.chemodan.queller.worker.CeleryOnetimeTask;
import ru.yandex.chemodan.queller.worker.CeleryOnetimeTaskParameters;
import ru.yandex.chemodan.util.json.JsonObjectUtils;
import ru.yandex.commune.bazinga.impl.TaskId;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;

/**
 * @author dbrylev
 */
public class PhotosliceUpdateNotificationCeleryOnetimeTask extends CeleryOnetimeTask {

    private final PhotosliceProcessingManager photosliceProcessingManager;

    public PhotosliceUpdateNotificationCeleryOnetimeTask(
            PhotosliceProcessingManager photosliceProcessingManager)
    {
        this.photosliceProcessingManager = photosliceProcessingManager;
    }

    @Override
    protected TaskId celeryTaskId() {
        return new TaskId("tasks.photosliceUpdateSnapshot"); // XXX sync with python method name
    }

    @Override
    protected void execute(CeleryOnetimeTaskParameters parameters, ExecutionContext context) throws Exception {
        DataApiUserId user = DataApiUserId.parse(JsonObjectUtils.getValueAsText(parameters.kwargs.getOrThrow("uid")));

        Option<Long> timestamp = parameters.kwargs.getO("timestamp").map(JsonObjectUtils::getValueAsLong);

        photosliceProcessingManager.handleSnapshotUpdate(user, timestamp.map(Instant::new));
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(10);
    }
}
