package ru.yandex.chemodan.app.smartcache.worker.clusterizer;

import org.junit.Before;
import org.junit.Test;

import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.misc.test.Assert;

/**
 * @author yashunsky
 */
public class BuildRequestUrlTest {
    private ClusterizerHttpProxy proxy;
    private DataApiUserId uid;
    private String clusterizerUrl = "host";

    @Before
    public void setup() {
        uid = DataApiUserId.parse("1");
        proxy = new ClusterizerHttpProxy(null, clusterizerUrl);
    }

    @Test
    public void createOnlineUrl() {
        String url = proxy.buildRequestUrlForTest(uid, clusterizerUrl, true, false);
        Assert.isTrue(url.contains("online=true"));
        Assert.isFalse(url.contains("fast-moved="));
    }

    @Test
    public void createOnlineFastMoveUrl() {
        String url = proxy.buildRequestUrlForTest(uid, clusterizerUrl, true, true);
        Assert.isTrue(url.contains("online=true"));
        Assert.isTrue(url.contains("fast-moved=true"));
    }

    @Test
    public void createOfflineUrl() {
        String url = proxy.buildRequestUrlForTest(uid, clusterizerUrl, false, false);
        Assert.isTrue(url.contains("online=false"));
        Assert.isFalse(url.contains("fast-moved="));
    }
}
