package ru.yandex.chemodan.app.smartcache.worker.clusterizer;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.mpfs.MpfsClient;
import ru.yandex.chemodan.util.http.HttpClientConfigurator;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author osidorkin
 */
@Configuration
public class ClusterizerClientContextConfiguration {

    @Value("${search.clusterizer.url}")
    private String clusterizerHostUrl;

    @Bean
    @OverridableValuePrefix("clusterizer")
    public HttpClientConfigurator clusterizerHttpClientConfigurator() {
        return new HttpClientConfigurator();
    }

    @Bean
    public ClusterizerHttpProxy clusterizerHttpProxy() {
        ListF<String> urls = Cf.x(clusterizerHostUrl.split(","))
                .map(StringUtils::trimToEmpty)
                .filter(StringUtils::isNotEmpty);

        return new ClusterizerHttpProxy(clusterizerHttpClientConfigurator().configure(), urls);
    }

    @Bean
    public ClusterizerManager clusterizerManager(ClusterizerHttpProxy clusterizerHttpProxy, MpfsClient mpfsClient) {
        return new ClusterizerManager(clusterizerHttpProxy, mpfsClient);
    }
}
