package ru.yandex.chemodan.app.smartcache.worker.clusterizer;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.app.smartcache.worker.clusterizer.pojo.PhotoViewLuceneClusterPojo;
import ru.yandex.chemodan.app.smartcache.worker.clusterizer.pojo.PhotoViewLuceneInfoPojo;
import ru.yandex.chemodan.app.smartcache.worker.utils.DynamicVars;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author osidorkin
 */
public class ClusterizerDuplicatesFilter {
    private static final Logger logger = LoggerFactory.getLogger(ClusterizerDuplicatesFilter.class);

    public static ListF<PhotoViewLuceneClusterPojo> removeClusterPathDuplicates(
            ListF<PhotoViewLuceneClusterPojo> clusters)
    {
        int limit = DynamicVars.photoCountLimit.get();

        MapF<String, PhotoViewLuceneInfoPojo> maxVersioned = Cf.hashMapWithExpectedSize(
                Math.min(clusters.iterator().map(c -> c.mergedDocs.size()).sum(Cf.Integer), limit));

        int photosRemain = 0, duplicatesCount = 0, maxClusterSize = 0;

        for (PhotoViewLuceneClusterPojo cluster: clusters) {
            if ((photosRemain += cluster.mergedDocs.size()) > limit) break;

            cluster.mergedDocs.forEach(c -> maxVersioned.merge(c.key, c, (l, r) -> l.version < r.version ? r : l));
            maxClusterSize = Math.max(maxClusterSize, cluster.mergedDocs.size());
        }

        ListF<PhotoViewLuceneClusterPojo> result = Cf.arrayListWithCapacity(clusters.size());
        ListF<PhotoViewLuceneInfoPojo> unique = Cf.arrayListWithCapacity(maxClusterSize);

        for (PhotoViewLuceneClusterPojo cluster: clusters) {
            if ((photosRemain -= cluster.mergedDocs.size()) < 0) break;

            cluster.mergedDocs.iterator().filter(c -> maxVersioned.getTs(c.key) == c).forEachRemaining(unique::add);

            if (unique.isNotEmpty()) {
                result.add(cluster.mergedDocs.size() == unique.size() ? cluster : new PhotoViewLuceneClusterPojo(
                        unique.size(), unique.last().date, unique.first().date, Cf.toList(unique)));
            }
            duplicatesCount += cluster.mergedDocs.size() - unique.size();
            unique.clear();
        }

        if (duplicatesCount != 0) {
            logger.warn("Found {} duplicates in clusterizer output", duplicatesCount);
        }
        return result;
    }
}
