package ru.yandex.chemodan.app.smartcache.worker.clusterizer;

import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.smartcache.worker.clusterizer.pojo.PhotoViewLuceneClusterPojo;
import ru.yandex.chemodan.app.smartcache.worker.clusterizer.pojo.PhotoViewLuceneResponsePojo;
import ru.yandex.chemodan.app.smartcache.worker.utils.DynamicVars;
import ru.yandex.chemodan.app.smartcache.worker.utils.PhotoViewCacheBender;
import ru.yandex.misc.bender.parse.BenderParser;
import ru.yandex.misc.io.http.UriBuilder;
import ru.yandex.misc.io.http.apache.v4.ApacheHttpClientUtils;
import ru.yandex.misc.io.http.apache.v4.ReadStringResponseHandler;
import ru.yandex.misc.lang.Check;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author osidorkin
 */
public class ClusterizerHttpProxy {

    private static final BenderParser<PhotoViewLuceneResponsePojo> clusterizerResponseParser
                            = PhotoViewCacheBender.searchMapper().createParser(PhotoViewLuceneResponsePojo.class);

    private static final String CLUSTERIZER_FIELDS = "id,key,date,latitude,longitude,width,height,cost_disk_aethetic_0,version,mediatype,photoslice_album_type,albums_exclusions";

    private final HttpClient clusterizerHttpClient;
    private final ListF<String> clusterizerUrls;

    public ClusterizerHttpProxy(HttpClient clusterizerHttpClient, String clusterizerUrl) {
        this.clusterizerHttpClient = clusterizerHttpClient;
        this.clusterizerUrls = Cf.list(clusterizerUrl);
    }

    public ClusterizerHttpProxy(HttpClient clusterizerHttpClient, ListF<String> clusterizerUrls) {
        this.clusterizerHttpClient = clusterizerHttpClient;
        this.clusterizerUrls = clusterizerUrls;
        Check.notEmpty(clusterizerUrls);
    }

    public ListF<PhotoViewLuceneClusterPojo> getUserClusters(DataApiUserId uid, boolean online, boolean quickMoveEnabled) {
        return requestClusters(uid, online, quickMoveEnabled).hitsArray;
    }

    private String buidRequestUrl(DataApiUserId uid, String clusterizerUrl, boolean online, boolean quickMoveEnabled) {
        UriBuilder builder = UriBuilder.cons(clusterizerUrl)
                .appendPath("clusterize")
//                .addParam("hr", true)
                .addParam("get", CLUSTERIZER_FIELDS)
                .addParam("uid", uid)
                .addParam("online", online);
        if (quickMoveEnabled) {
            builder = builder.addParam("fast-moved", true);
        }

        String url = builder.toUrl();
        String extraParams = DynamicVars.clusterizerExtraParams.get();
        if (StringUtils.isNotEmpty(extraParams)) {
            url = url + "&" + extraParams;
        }
        return url;
    }

    private PhotoViewLuceneResponsePojo requestClusters(DataApiUserId uid, boolean online, boolean quickMoveEnabled) {
        RuntimeException last = null;
        for (String url : clusterizerUrls) {
            try {
                return retrieveByHttpGet(buidRequestUrl(uid, url, online, quickMoveEnabled), clusterizerResponseParser);
            } catch (RuntimeException e) {
                last = e;
            }
        }
        throw last;
    }

    private <T> T retrieveByHttpGet(String url, BenderParser<T> parser) {
        return parser.parseJson(ApacheHttpClientUtils.execute(new HttpGet(url), clusterizerHttpClient, new ReadStringResponseHandler()));
    }

    public String buildRequestUrlForTest(DataApiUserId uid, String clusterizerUrl, boolean online, boolean quickMoveEnabled) {
        return buidRequestUrl(uid, clusterizerUrl, online, quickMoveEnabled);
    }
}
