package ru.yandex.chemodan.app.smartcache.worker.clusterizer;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.smartcache.worker.clusterizer.pojo.PhotoViewLuceneClusterPojo;
import ru.yandex.chemodan.mpfs.MpfsClient;
import ru.yandex.chemodan.mpfs.UserNotInitializedException;

/**
 * @author osidorkin
 */
public class ClusterizerManager {

    private final ClusterizerHttpProxy clusterizerHttpProxy;
    private final MpfsClient mpfsClient;

    public ClusterizerManager(ClusterizerHttpProxy clusterizerHttpProxy, MpfsClient mpfsClient) {
        this.clusterizerHttpProxy = clusterizerHttpProxy;
        this.mpfsClient = mpfsClient;
    }

    public ListF<PhotoViewLuceneClusterPojo> getUserClusters(DataApiUserId uid, boolean online) {
        try {
            boolean quickMoveEnabled = mpfsClient.isQuickMoveEnabled(uid.toString());
            return ClusterizerDuplicatesFilter.removeClusterPathDuplicates(
                    clusterizerHttpProxy.getUserClusters(uid, online, quickMoveEnabled));
        } catch (UserNotInitializedException e) {
            // Если юзера нет в мпфс не хочется отдавать 500-ку. Запишем в базу, что у него нету фотосреза
            // Когда юзер проинициализируется - фотосрез автоматически обновится без проблем
            return Cf.list();
        }
    }
}
