package ru.yandex.chemodan.app.smartcache.worker.clusterizer.pojo;

import lombok.AllArgsConstructor;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.misc.enums.IntEnum;
import ru.yandex.misc.enums.IntEnumResolver;

/**
 * @author yashunsky
 */
@AllArgsConstructor
public enum AlbumType implements IntEnum {
    // using same values as in mobile client
    // PhotosliceAlbumId = 0 skipped as redundant
    // photounlim not currently implemented in mobile
    CAMERA(1),
    SCREENSHOTS(2),
    VIDEOS(3),
    BEAUTIFUL(7),
    UNBEAUTIFUL(8),
    PHOTOUNLIM(9),
    NONPHOTOUNLIM(10);

    private final int bit;

    // using same values as in mobile client
    public static final double BEAUTIFUL_EDGE = 1.31;
    public static final double UNBEAUTIFUL_EDGE = -5;

    public static SetF<AlbumType> getMatching(String path, Option<Double> beauty, Option<String> mediaType,
            Option<AlbumType> cameraOrScreenshot, ListF<AlbumType> exclusion)
    {
        SetF<AlbumType> albums = Cf.hashSet();

        if (path.startsWith("/photounlim")) {
            albums.add(PHOTOUNLIM);
        } else {
            albums.add(NONPHOTOUNLIM);
        }

        if (beauty.exists(value -> value >= BEAUTIFUL_EDGE)) {
            albums.add(BEAUTIFUL);
        }

        if (beauty.exists(value -> value <= UNBEAUTIFUL_EDGE)) {
            albums.add(UNBEAUTIFUL);
        }

        if (mediaType.containsTs("12")) { // search value for video
            albums.add(VIDEOS);
        }

        albums.addAll(cameraOrScreenshot);
        albums.removeAllTs(exclusion);

        if (albums.containsTs(AlbumType.SCREENSHOTS)) {
            albums.removeTs(AlbumType.BEAUTIFUL);
            albums.removeTs(AlbumType.UNBEAUTIFUL);
        }

        return albums;
    }

    @Override
    public int value() {
        return bit;
    }

    public static final IntEnumResolver<AlbumType> R = IntEnumResolver.r(AlbumType.class);

    public static Option<AlbumType> valueOfSafe(String value) {
        try {
            return Option.of(AlbumType.valueOf(value.toUpperCase()));
        } catch (IllegalArgumentException ignore) {
            return Option.empty();
        }
    }
}
