package ru.yandex.chemodan.app.smartcache.worker.clusterizer.pojo;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.test.Assert;

/**
 * @author yashunsky
 */
public class AlbumsTypeMatchingTest {
    @Test
    public void beautifulVideoFromPhotounlimCamera() {
        Assert.equals(Cf.set(AlbumType.CAMERA, AlbumType.VIDEOS, AlbumType.BEAUTIFUL, AlbumType.PHOTOUNLIM),
                AlbumType.getMatching("/photounlim/2019-11-05 13:07:55.avi", Option.of(10.0), Option.of("12"),
                        Option.of(AlbumType.CAMERA), Cf.list()));
    }

    @Test
    public void cameraExcludedFromBeautiful() {
        Assert.equals(Cf.set(AlbumType.CAMERA, AlbumType.NONPHOTOUNLIM),
                AlbumType.getMatching("/disk/2019-11-05 13:07:64.png", Option.of(10.0), Option.of("9"),
                        Option.of(AlbumType.CAMERA), Cf.list(AlbumType.BEAUTIFUL)));
    }
}
