package ru.yandex.chemodan.app.smartcache.worker.clusterizer.pojo;

import org.joda.time.Instant;
import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.smartcache.worker.utils.PhotoViewCacheBender;
import ru.yandex.misc.bender.parse.BenderParser;
import ru.yandex.misc.io.ClassPathResourceInputStreamSource;
import ru.yandex.misc.test.Assert;

/**
 * @author osidorkin
 */
public class PhotoViewBenderTest {

    @Test
    public void testSingleItemParsing() {
        String item = " { \n"
                    + "\"id\": \"020929811ec3edc2a44e4c90338fadf246713e71b448a9c7b4281332cf393204\",\n"
                    + "\"key\": \"/disk/Святое 29-30.11.2014/Разуваем пламя газовой горелкой. Андрей слева.JPG\",\n"
                    + "\"date\": \"1420802519\",\n"
                    + "\"latitude\": \"55.640378\",\n"
                    + "\"longitude\": \"42.310467\",\n"
                    + "\"width\": \"1024\",\n"
                    + "\"height\": \"768\",\n"
                    + "\"cost_disk_aethetic_0\": \"-5.87659\",\n"
                    + "\"version\": \"1432306530490680\",\n"
                    + "\"mediatype\": \"9\",\n"
                    + "\"photoslice_album_type\": \"camera\",\n"
                    + "\"albums_exclusions\": \"unbeautiful\\nvideos\\nthis_will_never_be_an_album\"\n"
                + "}\n";
        BenderParser<PhotoViewLuceneInfoPojo> parser = PhotoViewCacheBender.searchMapper().createParser(PhotoViewLuceneInfoPojo.class);
        PhotoViewLuceneInfoPojo parsedItem = parser.parseJson(item);
        PhotoViewLuceneInfoPojo expectedItem = new PhotoViewLuceneInfoPojo("020929811ec3edc2a44e4c90338fadf246713e71b448a9c7b4281332cf393204",
                "/disk/Святое 29-30.11.2014/Разуваем пламя газовой горелкой. Андрей слева.JPG",
                new Instant(1420802519000L), Option.of(42.310467), Option.of(55.640378),
                Option.of(1024), Option.of(768), Option.of(-5.87659d), 1432306530490680L,
                Option.of("9"), Option.of(AlbumType.CAMERA), Option.of("unbeautiful"), false);

        Assert.equals(expectedItem, parsedItem);
        Assert.equals(Cf.set(AlbumType.CAMERA, AlbumType.NONPHOTOUNLIM), parsedItem.getAlbums());
    }

    @Test
    public void testClusterParsing() {
        String cluster = "{\n"
                            + "\"size\": 2,\n"
                            + "\"max\": 1417324906,\n"
                            + "\"min\": 1417268610,\n"
                            + "\"merged_docs\": [\n"
                            + "{\n"
                            + "\"id\": \"020929811ec3edc2a44e4c90338fadf246713e71b448a9c7b4281332cf393204\",\n"
                            + "\"key\": \"/disk/Святое 29-30.11.2014/Разуваем пламя газовой горелкой. Андрей слева.JPG\","
                            + "\"date\": \"1417807199\",\n"
                            + "\"latitude\": \"55.640378\",\n"
                            + "\"longitude\": \"42.310467\",\n"
                            + "\"version\": \"1433151140333346\"\n"
                            + "},\n"
                            + "{\n"
                            + "\"id\": \"d45b2a49f9a628827939504b10c6a3b7501c6e9a4ae11a5bb964c4708e2d9c97\",\n"
                            + "\"key\": \"/disk/Святое 29-30.11.2014/Гамиль.JPG\",\n"
                            + "\"date\": \"1417807199\",\n"
                            + "\"latitude\": \"55.640719\",\n"
                            + "\"longitude\": \"42.310478\",\n"
                            + "\"version\": \"1432306530490680\"\n"
                            + "}\n"
                            + "]\n"
                       + "}\n";
        BenderParser<PhotoViewLuceneClusterPojo> parser = PhotoViewCacheBender.searchMapper().createParser(PhotoViewLuceneClusterPojo.class);
        Assert.equals(new PhotoViewLuceneClusterPojo(2, new Instant(1417268610000L), new Instant(1417324906000L),
                       Cf.list(new PhotoViewLuceneInfoPojo("020929811ec3edc2a44e4c90338fadf246713e71b448a9c7b4281332cf393204",
                                   "/disk/Святое 29-30.11.2014/Разуваем пламя газовой горелкой. Андрей слева.JPG",
                                   new Instant(1417807199000L), Option.of(42.310467), Option.of(55.640378),
                                   1433151140333346L),
                               new PhotoViewLuceneInfoPojo("d45b2a49f9a628827939504b10c6a3b7501c6e9a4ae11a5bb964c4708e2d9c97",
                                   "/disk/Святое 29-30.11.2014/Гамиль.JPG",
                                   new Instant(1417807199000L), Option.of(42.310478), Option.of(55.640719),
                                   1432306530490680L)
                               )),
               parser.parseJson(cluster));
    }

    @Test
    public void testResponseParsing() {
        PhotoViewLuceneResponsePojo response = PhotoViewCacheBender.searchMapper().parseJson(PhotoViewLuceneResponsePojo.class,
                new ClassPathResourceInputStreamSource(getClass(), "response.json"));
        Assert.equals(12, response.hitsCount);
        Assert.equals(12, response.hitsArray.size());
        Assert.equals(new PhotoViewLuceneInfoPojo("0b715c322563822d72424d192394a15ebff75d15710af32035c0501d99d9b193",
                                              "/disk/Загрузки/2015-05-30 22-46-48.JPG",
                                              new Instant(1433015208000L), Option.of(37.640747), Option.of(55.787914),
                                              1433151140333346L),
                       response.hitsArray.first().mergedDocs.first());
        Assert.equals(new PhotoViewLuceneInfoPojo("370afe04f95ac4992843aea4ab1c21b1aad5d0697fa1a617ed28e6420ad88f16",
                                              "/disk/Фото/1980-01-07 01-14-46.JPG",
                                              new Instant(316041284000L), Option.empty(), Option.empty(),
                                              1432306530490680L),
                       response.hitsArray.last().mergedDocs.last());
    }
}
