package ru.yandex.chemodan.app.smartcache.worker.clusterizer.pojo;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.smartcache.worker.utils.PojoConverters;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderIgnore;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author osidorkin
 */
@BenderBindAllFields
public class PhotoViewLuceneClusterPojo extends DefaultObject {

    public final int size;
    public final Instant min;
    public final Instant max;
    @BenderPart(name = "merged_docs", strictName = true)
    public final ListF<PhotoViewLuceneInfoPojo> mergedDocs;
    @BenderIgnore
    private transient String photosHash;

    public PhotoViewLuceneClusterPojo(int size, Instant min, Instant max, ListF<PhotoViewLuceneInfoPojo> mergedDocs) {
        this.size = size;
        this.min = min;
        this.max = max;
        this.mergedDocs = mergedDocs;
    }

    public PhotoViewLuceneClusterPojo withNoAlbums() {
        return new PhotoViewLuceneClusterPojo(size, min, max, mergedDocs.map(PhotoViewLuceneInfoPojo::withNoAlbums));
    }

    public static PhotoViewLuceneClusterPojo empty(Instant bound) {
        return new PhotoViewLuceneClusterPojo(0, bound, bound, Cf.list());
    }

    public String getPhotosHash() {
        if (photosHash == null) {
            photosHash = PojoConverters.computePhotosHash(mergedDocs);
        }
        return photosHash;
    }

    public PhotoViewLuceneClusterPojo setPhotosHashForTestReturnThis(String hash) {
        photosHash = hash;
        return this;
    }
}
