package ru.yandex.chemodan.app.smartcache.worker.dataapi;

import lombok.AllArgsConstructor;
import lombok.Data;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.smartcache.worker.clusterizer.pojo.AlbumType;

/**
 * @author osidorkin
 */
@AllArgsConstructor
@Data
public class DisplayedCluster {

    protected final ClusterId id;
    protected final Instant from;
    protected final Instant to;
    protected final int photosCount;
    protected final Option<String> photosHash;
    protected final Option<LocalizedStringDictionary> localityO;
    protected final ListF<LocalizedStringDictionary> places;
    protected final MapF<AlbumType, Integer> albumsEntries;

    public String getIdForDb() {
        return id.formatForDb();
    }

    public int getPhotosInAlbumCount(AlbumType type) {
        return albumsEntries.getO(type).getOrElse(0);
    }

    public boolean hasPhotosInAlbum(AlbumType type) {
        return getPhotosInAlbumCount(type) > 0;
    }
}
