package ru.yandex.chemodan.app.smartcache.worker.dataapi;


import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.smartcache.worker.clusterizer.pojo.AlbumType;
import ru.yandex.chemodan.app.smartcache.worker.clusterizer.pojo.PhotoViewLuceneInfoPojo;

/**
 * @author osidorkin
 */
public final class IndexedCluster extends DisplayedCluster {
    private final ListF<PhotoViewLuceneInfoPojo> photos;

    private IndexedCluster(
            ClusterId id, Instant from, Instant to,
            int photosCount, Option<String> photosHash,
            Option<LocalizedStringDictionary> cityO, ListF<LocalizedStringDictionary> locations,
            ListF<PhotoViewLuceneInfoPojo> photos, Option<MapF<AlbumType, Integer>> albumsEntries)
    {
        super(id, from, to, photosCount, photosHash, cityO, locations,
                albumsEntries.getOrElse(photos.flatMap(PhotoViewLuceneInfoPojo::getAlbums).countBy()));
        this.photos = photos;
    }

    public boolean isNotLoaded() {
        return photosCount > 0 && photos.isEmpty();
    }

    public ListF<PhotoViewLuceneInfoPojo> getPhotos() {
        return photos;
    }

    public boolean hasPhotoWithCoordinates() {
        return photos.exists(PhotoViewLuceneInfoPojo::hasCoordinates);
    }

    public IndexedCluster withGeoLocality(Option<LocalizedStringDictionary> newLocalityO) {
        if (newLocalityO.equals(this.localityO)) {
            return this;
        }
        return new IndexedCluster(
                id, from, to, photosCount, photosHash, newLocalityO, places, photos, Option.of(albumsEntries));
    }

    public IndexedCluster withGeoPlaces(ListF<LocalizedStringDictionary> newPlaces) {
        if (newPlaces.isEmpty() && this.places.isEmpty()) {
            return this;
        }
        return new IndexedCluster(
                id, from, to, photosCount, photosHash, localityO, newPlaces, photos, Option.of(albumsEntries));
    }

    public static IndexedCluster consFromLuceneData(
            ClusterId.Format format, Instant from, Instant to,
            int photosNum, Option<String> photosHash, ListF<PhotoViewLuceneInfoPojo> photos)
    {
        return new IndexedCluster(
                format.cons(from, to), from, to,
                photosNum, photosHash, Option.empty(), Cf.list(), photos, Option.empty());
    }

    public static IndexedCluster consFromDataApi(DisplayedCluster displayedCluster, ListF<PhotoViewLuceneInfoPojo> photos)
    {
        return new IndexedCluster(
                displayedCluster.getId(), displayedCluster.getFrom(), displayedCluster.getTo(),
                displayedCluster.getPhotosCount(), displayedCluster.getPhotosHash(),
                displayedCluster.getLocalityO(), displayedCluster.getPlaces(), photos,
                Option.of(displayedCluster.albumsEntries));
    }

    public IndexedCluster withId(ClusterId id) {
        return new IndexedCluster(
                id, from, to, photosCount, photosHash, localityO, places, photos, Option.of(albumsEntries));
    }

}
