package ru.yandex.chemodan.app.smartcache.worker.dataapi;

import java.util.EnumMap;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.bolts.collection.impl.UnmodifiableDefaultMapF;
import ru.yandex.inside.utils.Language;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author osidorkin
 */
public class LocalizedStringDictionary extends DefaultObject {

    public static final ListF<Language> languages = Cf.wrap(new Language[]{
            Language.RUSSIAN, Language.ENGLISH, Language.UKRAINIAN, Language.TURKISH});

    public static final Language defaultLanguage = Language.ENGLISH;

    private final MapF<Language, String> dictionary;

    public LocalizedStringDictionary(ListF<String> resources) {
        this(languages.zip(resources));
    }

    public LocalizedStringDictionary(Tuple2List<Language, String> resources) {
        this(resources.toMap());
    }

    public LocalizedStringDictionary(MapF<Language, String> resources) {
        dictionary = UnmodifiableDefaultMapF.wrap(new EnumMap<>(resources));
    }

    public String getDefaultResource() {
        return dictionary.getOrThrow(defaultLanguage);
    }

    public String getResource(Language language) {
        return dictionary.getO(language).getOrElse(this::getDefaultResource);
    }

    public ListF<String> toList() {
        return languages.map(this::getResource);
    }

    public MapF<Language, String> toMap() {
        return dictionary;
    }
}
