package ru.yandex.chemodan.app.smartcache.worker.dataapi;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.inside.utils.Language;
import ru.yandex.misc.test.Assert;

/**
 * @author osidorkin
 */
public class LocalizedStringDictionaryTest {

    @Test
    public void toList() {
        LocalizedStringDictionary dict = new LocalizedStringDictionary(Tuple2List.wrap(Cf.list(
                                            Tuple2.tuple(Language.ENGLISH, "Moscow"),
                                            Tuple2.tuple(Language.RUSSIAN, "Москва"))));
        Assert.equals(Cf.list("Москва", "Moscow", "Moscow", "Moscow"), dict.toList());
        Assert.equals("Moscow", dict.getResource(Language.ENGLISH));
        Assert.equals("Москва", dict.getResource(Language.RUSSIAN));
        Assert.equals(dict, new LocalizedStringDictionary(Cf.list("Москва", "Moscow")));
    }

    @Test
    public void getDefault() {
        LocalizedStringDictionary dict = new LocalizedStringDictionary(Tuple2List.wrap(Cf.list(
                Tuple2.tuple(Language.ENGLISH, "Moscow"))));
        Assert.equals(dict.getDefaultResource(), dict.getResource(Language.RUSSIAN));
    }
}
