package ru.yandex.chemodan.app.smartcache.worker.dataapi.cleanup;

import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.Minutes;

import ru.yandex.chemodan.app.smartcache.worker.utils.DynamicVars;
import ru.yandex.misc.worker.spring.DelayingWorkerServiceBeanSupport;

/**
 * @author friendlyevil
 */
public class CleaningLagWorkerService extends DelayingWorkerServiceBeanSupport {
    private final DeltaAccessTimeMdao deltaAccessTimeMdao;

    public CleaningLagWorkerService(DeltaAccessTimeMdao deltaAccessTimeMdao) {
        this.deltaAccessTimeMdao = deltaAccessTimeMdao;
    }

    @Override
    protected Duration defaultDelay() {
        return Minutes.minutes(20).toStandardDuration();
    }

    @Override
    protected void execute() throws Exception {
        int count = getCleaningQueueSize();
        CleanupMetrics.cleaningQueueSize.set(count);
    }

    public int getCleaningQueueSize() {
        int expirationDays = DynamicVars.photosliceDeltaExpirationDays.get();
        Instant expirationInstant = Instant.now().minus(Duration.standardDays(expirationDays));
        return deltaAccessTimeMdao.countTrackedItemsBefore(expirationInstant);
    }
}
