package ru.yandex.chemodan.app.smartcache.worker.dataapi.cleanup;

import ru.yandex.misc.monica.annotation.GroupByDefault;
import ru.yandex.misc.monica.annotation.MonicaMetric;
import ru.yandex.misc.monica.annotation.MonicaStaticRegistry;
import ru.yandex.misc.monica.core.blocks.Meter;
import ru.yandex.misc.monica.core.blocks.MeterMap;
import ru.yandex.misc.monica.core.blocks.Value;
import ru.yandex.misc.monica.core.name.MetricGroupName;
import ru.yandex.misc.monica.core.name.MetricName;

/**
 * @author friendlyevil
 */
public class CleanupMetrics {

    @GroupByDefault
    @MonicaMetric
    public final static MeterMap exceptionsByShard = new MeterMap();

    @GroupByDefault
    @MonicaMetric
    public final static MeterMap postgresqlDeleteRequestByShard = new MeterMap();

    @GroupByDefault
    @MonicaMetric
    public final static MeterMap postgresqlDropAllDeltasByShard = new MeterMap();

    @GroupByDefault
    @MonicaMetric
    public final static MeterMap successDeleteByShard = new MeterMap();

    @GroupByDefault
    @MonicaMetric
    public final static Meter mongoGetDeltasToDelete = new Meter();

    @GroupByDefault
    @MonicaMetric(name = "cleaningQueueSize_max")
    public final static Value<Integer> cleaningQueueSize = new Value<>(0);

    static {
        MonicaStaticRegistry.register(
                CleanupMetrics.class,
                new MetricGroupName(
                        "smartcache-worker-cleanup-metrics",
                        new MetricName("smartcache-worker", "cleanup-metrics"),
                        "Smartcache worker cleanup metrics"
                )
        );
    }
}
