package ru.yandex.chemodan.app.smartcache.worker.dataapi.cleanup;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;

public class DefaultDeltaCleanupData implements DeltaCleanupData {

    public static DefaultDeltaCleanupData create() {
        return new DefaultDeltaCleanupData(new AtomicInteger(0), new HashSet<>());
    }

    public static DefaultDeltaCleanupData createConcurrent() {
        return new DefaultDeltaCleanupData(new AtomicInteger(0), ConcurrentHashMap.newKeySet());
    }

    private final AtomicInteger removedSnapshotCount;
    private final Set<DataApiUserId> failedUids;

    protected DefaultDeltaCleanupData(AtomicInteger removedSnapshotCount, Set<DataApiUserId> failedUids) {
        this.removedSnapshotCount = removedSnapshotCount;
        this.failedUids = failedUids;
    }

    @Override
    public void addRemovedSnapshotCount(int count) {
        removedSnapshotCount.addAndGet(count);
    }

    @Override
    public void addFailedUid(DataApiUserId uid) {
        failedUids.add(uid);
    }

    @Override
    public void removeFailedUid(DataApiUserId uid) {
        failedUids.remove(uid);
    }

    @Override
    public List<DataApiUserId> getFailedUids() {
        return new ArrayList<>(failedUids);
    }

    @Override
    public int getRemovedSnapshotsCount() {
        return removedSnapshotCount.get();
    }
}
