package ru.yandex.chemodan.app.smartcache.worker.dataapi.cleanup;

import com.mongodb.BasicDBObject;
import com.mongodb.client.MongoDatabase;
import org.bson.BsonDocument;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.smartcache.worker.utils.PhotoViewCacheBender;
import ru.yandex.chemodan.mongo.AbstractMongoDao;
import ru.yandex.commune.mongo3.MongoCollectionX;
import ru.yandex.commune.mongo3.schema.IndexInfo;
import ru.yandex.commune.mongo3.schema.SortOrder;
import ru.yandex.misc.db.q.SqlLimits;
import ru.yandex.misc.db.q.SqlOrder;

/**
 * @author osidorkin
 */
public class DeltaAccessTimeMdao extends AbstractMongoDao<MongoDeltaId, TrackedDelta> {

    public DeltaAccessTimeMdao(MongoDatabase database) {
        super(database, new MongoCollectionX<>(
                database.getCollection("deltaAceessTime", BsonDocument.class),
                TrackedDelta.class, PhotoViewCacheBender.clientA3BenderConfiguration()));
    }

    public void startTracking(DataApiUserId uid, String handle, long revision) {
        startTracking(new TrackedDelta(id(uid, handle), revision, Instant.now().getMillis()));
    }

    void startTracking(TrackedDelta trackedDelta) {
        collection.insertOrUpdateOne(trackedDelta);
    }

    public void removeTracking(DataApiUserId uid, String handle) {
        collection.deleteOne(id(uid, handle));
    }

    public void recordAccess(DataApiUserId uid, String handle) {
        collection.updateOneById(id(uid, handle),
                new BasicDBObject("$set", new BasicDBObject("lastAccessed", Instant.now().getMillis())));
    }

    public Option<TrackedDelta> getTrackedItem(DataApiUserId uid, String handle) {
        return collection.findById(id(uid, handle));
    }

    public ListF<TrackedDelta> getTrackedItemsBefore(Instant instant, int limit) {
        return collection.find(new BasicDBObject("lastAccessed", new BasicDBObject("$lte", instant.getMillis())),
                SqlOrder.unordered(), SqlLimits.first(limit));
    }

    public ListF<TrackedDelta> getTrackedItemsBefore(Instant instant, int first, int limit) {
        return collection.find(new BasicDBObject("lastAccessed", new BasicDBObject("$lte", instant.getMillis())),
                SqlOrder.orderByColumn("lastAccessed"), SqlLimits.range(first, limit));
    }

    public int countTrackedItemsBefore(Instant instant) {
        return (int) collection.count(new BasicDBObject("lastAccessed", new BasicDBObject("$lte", instant.getMillis())));
    }

    private static MongoDeltaId id(DataApiUserId uid, String handle) {
        return new MongoDeltaId(uid, handle);
    }

    @Override
    public ListF<IndexInfo> getIndexes() {
        return Cf.list(new IndexInfo().key("lastAccessed", SortOrder.DESC));
    }

}
