package ru.yandex.chemodan.app.smartcache.worker.dataapi.cleanup;

import com.mongodb.client.MongoDatabase;
import org.bson.BsonDocument;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.smartcache.worker.utils.PhotoViewCacheBender;
import ru.yandex.chemodan.mongo.AbstractMongoDao;
import ru.yandex.commune.mongo3.MongoCollectionX;
import ru.yandex.commune.mongo3.schema.IndexInfo;

/**
 * @author osidorkin
 */
public class LastRetrievedRevisionTrackerMdao extends AbstractMongoDao<MongoDeltaId, TrackedRevision> {

    public LastRetrievedRevisionTrackerMdao(MongoDatabase database) {
        super(database, new MongoCollectionX<>(
                database.getCollection("lastRetrievedRevision", BsonDocument.class),
                TrackedRevision.class, PhotoViewCacheBender.clientA3BenderConfiguration()));
    }

    public void updateRevision(DataApiUserId uid, String handle, long revision) {
        collection.insertOrUpdateOne(new TrackedRevision(id(uid, handle), revision));
    }

    public void untrackRevision(DataApiUserId uid, String handle) {
        collection.deleteOne(id(uid, handle));
    }

    public Option<Long> getCurrentRevision(DataApiUserId uid, String handle) {
        return collection.findById(id(uid, handle)).map(trackedRevision -> trackedRevision.revision);
    }

    private static MongoDeltaId id(DataApiUserId uid, String handle) {
        return new MongoDeltaId(uid, handle);
    }

    @Override
    public ListF<IndexInfo> getIndexes() {
        return Cf.list();
    }
}
