package ru.yandex.chemodan.app.smartcache.worker.dataapi.handlers;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.smartcache.worker.dataapi.handlers.async.XivaPushSender;
import ru.yandex.chemodan.xiva.DiskXivaServices;
import ru.yandex.chemodan.xiva.XivaClient;
import ru.yandex.chemodan.xiva.XivaClientContextConfiguration;

/**
 * @author Denis Bakharev
 */
@Configuration
@Import(XivaClientContextConfiguration.class)
public class HandlersContextConfiguration {

    @Bean
    public XivaPushSender xivaPushSender(
            XivaClient xivaClient)
    {
        return new XivaPushSender(xivaClient.toSingleTokenClient(DiskXivaServices.DISK_JSON));
    }
}
