package ru.yandex.chemodan.app.smartcache.worker.dataapi.mappers;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.support.RecordField;
import ru.yandex.chemodan.app.smartcache.worker.clusterizer.pojo.AlbumType;
import ru.yandex.misc.enums.IntEnumResolver;

/**
 * @author yashunsky
 */
public class AlbumsBitMaskUtils {
    public static RecordField<SetF<AlbumType>> bitEnumSet(String name) {
        return new RecordField<>(name,
                AlbumsBitMaskUtils::bitEnumSetValue,
                AlbumsBitMaskUtils::bitEnumSet,
                Option.empty()
        );
    }

    public static long getBitMask(SetF<AlbumType> albums) {
        long mask = 0;
        for (AlbumType album : albums) {
            mask |= 1 << album.value();
        }
        return mask;
    }

    public static DataField bitEnumSet(SetF<AlbumType> albums) {
        return DataField.integer(getBitMask(albums));
    }

    public static SetF<AlbumType> bitEnumSetValue(DataField dataField) {
        long mask = dataField.integerValue();
        IntEnumResolver<AlbumType> resolver = AlbumType.R;
        return resolver.values().filter(value -> (mask & (1 << value)) > 0).filterMap(resolver::fromValueO).unique();
    }

}
