package ru.yandex.chemodan.app.smartcache.worker.dataapi.mappers;

import org.joda.time.Instant;

import ru.yandex.chemodan.app.smartcache.worker.clusterizer.pojo.PhotoViewLuceneInfoPojo;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author dbrylev
 */
public class PhotoRecordId {

    public enum Format {
        STALE(TimestampFormatter.NUMERIC),
        ADVANCED(TimestampFormatter.PRINTED);

        private final TimestampFormatter formatter;

        Format(TimestampFormatter formatter) {
            this.formatter = formatter;
        }

        private Instant parseDate(String str) {
            return formatter.parse(str);
        }
    }

    public final Instant date;
    public final String fileId;
    public final long version;

    public PhotoRecordId(Instant date, String fileId, long version) {
        this.date = date;
        this.fileId = fileId;
        this.version = version;
    }

    public static PhotoRecordId of(PhotoViewLuceneInfoPojo photo) {
        return new PhotoRecordId(photo.date, photo.id, photo.version);
    }

    public static String formatForView(String value) {
        if (value.startsWith("2_")) {
            return value;
        }
        return parse(value).format(Format.STALE);
    }

    public String format(Format format) {
        if (format == Format.STALE) {
            return "2_" + format.formatter.format(date) + "_" + fileId + "_" + version;
        }
        return format.formatter.format(date) + "_" + fileId + "_" + version;
    }

    public static PhotoRecordId parse(String value) {
        String[] parts = StringUtils.split(value, '_');

        if (value.startsWith("2_")) {
            return new PhotoRecordId(Format.STALE.parseDate(parts[1]), parts[2], Long.parseLong(parts[3]));
        }
        return new PhotoRecordId(Format.ADVANCED.parseDate(parts[0]), parts[1], Long.parseLong(parts[2]));
    }

    @Override
    public String toString() {
        return format(Format.STALE);
    }
}
