package ru.yandex.chemodan.app.smartcache.worker.dataapi.mappers;

import org.joda.time.Instant;
import org.joda.time.format.DateTimeFormat;

import ru.yandex.bolts.function.Function;
import ru.yandex.bolts.function.Function1B;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author dbrylev
 */
public enum TimestampFormatter {

    NUMERIC(
            str -> Character.isDigit(str.charAt(str.length() - 1)),
            str -> new Instant(Long.parseLong(str)),
            ts -> ts.getMillis() < 0
                    ? "-" + StringUtils.leftPad(Long.toString(-ts.getMillis()), 18, '0')
                    : StringUtils.leftPad(Long.toString(ts.getMillis()), 19, '0')),
    PRINTED(
            str -> str.charAt(str.length() - 1) == 'Z',
            str -> DateTimeFormat.forPattern("YYYYMMddHHmmssSSSZ").parseDateTime(str).toInstant(),
            ts -> ts.toString(DateTimeFormat.forPattern("YYYYMMddHHmmssSSS'Z'")));

    private final Function1B<String> matches;
    private final Function<String, Instant> parse;
    private final Function<Instant, String> format;

    TimestampFormatter(
            Function1B<String> matches,
            Function<String, Instant> parse,
            Function<Instant, String> format)
    {
        this.matches = matches;
        this.parse = parse;
        this.format = format;
    }

    public boolean matches(String value) {
        return !value.isEmpty() && matches.apply(value);
    }

    public Instant parse(String value) {
        return parse.apply(value);
    }

    public String format(Instant value) {
        return format.apply(value);
    }
}
