package ru.yandex.chemodan.app.smartcache.worker.dataapi.mappers;

import org.joda.time.Instant;
import org.junit.Test;

import ru.yandex.misc.test.Assert;

/**
 * @author dbrylev
 */
public class TimestampFormatterTest {

    @Test
    public void parse() {
        Assert.equals(Instant.parse("2018-10-12T13:14:15.111Z"), TimestampFormatter.PRINTED.parse("20181012131415111Z"));
        Assert.equals(new Instant(2000), TimestampFormatter.NUMERIC.parse("0000000000000002000"));
        Assert.equals(new Instant(-1000), TimestampFormatter.NUMERIC.parse("-000000000000001000"));
    }

    @Test
    public void format() {
        Assert.equals("20181012131415111Z", TimestampFormatter.PRINTED.format(Instant.parse("2018-10-12T13:14:15.111Z")));
        Assert.equals("0000000000000002000", TimestampFormatter.NUMERIC.format(new Instant(2000)));
        Assert.equals("-000000000000001000", TimestampFormatter.NUMERIC.format(new Instant(-1000)));
    }
}
