package ru.yandex.chemodan.app.smartcache.worker.processing;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.geo.Coordinates;

/**
 * @author osidorkin
 */
public interface CoordinatesAware {

    Option<Double> getLongitudeO();
    Option<Double> getLatitudeO();

    default boolean hasCoordinates() {
        return getLongitudeO().isPresent() && getLatitudeO().isPresent();
    }

    default Option<Coordinates> getCoordinatesO() {
        return Option.when(hasCoordinates(), () -> new Coordinates(getLatitudeO().get(), getLongitudeO().get()));
    }

}
