package ru.yandex.chemodan.app.smartcache.worker.processing;

import lombok.Data;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.smartcache.worker.dataapi.LocalizedStringDictionary;

@Data
public class GeoPlaceLocalizedNames {
    public static final GeoPlaceLocalizedNames EMPTY = new GeoPlaceLocalizedNames(Option.empty(), Option.empty());

    private final Option<LocalizedStringDictionary> locality;
    private final Option<LocalizedStringDictionary> street;

    public boolean isEmpty() {
        return !locality.isPresent() && !street.isPresent();
    }
}
