package ru.yandex.chemodan.app.smartcache.worker.processing.clusterMatching;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.app.smartcache.worker.clusterizer.pojo.PhotoViewLuceneClusterPojo;
import ru.yandex.chemodan.app.smartcache.worker.dataapi.ClusterId;
import ru.yandex.chemodan.app.smartcache.worker.dataapi.IndexedCluster;
import ru.yandex.chemodan.app.smartcache.worker.processing.clusterMatching.diffs.DiffType;
import ru.yandex.chemodan.app.smartcache.worker.processing.clusterMatching.diffs.EntireClusterDiff;
import ru.yandex.chemodan.app.smartcache.worker.processing.clusterMatching.diffs.MatchedClustersDiff;
import ru.yandex.chemodan.app.smartcache.worker.utils.PojoConverters;

/**
 * @author osidorkin
 */
public interface ClusterDiff {

    static EntireClusterDiff clusterAdded(IndexedCluster cluster) {
        return EntireClusterDiff.clusterAdded(cluster);
    }

    static EntireClusterDiff clusterAdded(ClusterId.Format format, PhotoViewLuceneClusterPojo cluster) {
        return clusterAdded(PojoConverters.buildClustersIndex(format, cluster));
    }

    static EntireClusterDiff clusterRemoved(IndexedCluster cluster) {
        return EntireClusterDiff.clusterRemoved(cluster);
    }

    static MatchedClustersDiff majorityMatch(IndexedCluster cluster, PhotoViewLuceneClusterPojo clusterPojo, int matchedPhotosCount) {
        return MatchedClustersDiff.majorityMatch(cluster, clusterPojo, matchedPhotosCount);
    }

    static MatchedClustersDiff exactMatch(IndexedCluster cluster, PhotoViewLuceneClusterPojo clusterPojo, int matchedPhotosCount) {
        return MatchedClustersDiff.exactMatch(cluster, clusterPojo, matchedPhotosCount);
    }

    DiffType getType();
    IndexedCluster getCluster();
    Option<IndexedCluster> getClusterUpdate();
    ClusterDiff addGeoData(Function<IndexedCluster, IndexedCluster> withGeobaseData);
    ClusterDiff withCluster(IndexedCluster cluster);
}
