package ru.yandex.chemodan.app.smartcache.worker.processing.clusterMatching.diffs;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.app.smartcache.worker.dataapi.IndexedCluster;
import ru.yandex.chemodan.app.smartcache.worker.processing.clusterMatching.ClusterDiff;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author osidorkin
 */
public final class EntireClusterDiff extends DefaultObject implements ClusterDiff {

    private final DiffType diffType;
    private final IndexedCluster cluster;

    private EntireClusterDiff(IndexedCluster cluster, DiffType diffType) {
        this.cluster = cluster;
        this.diffType = diffType;
    }

    public IndexedCluster getCluster() {
        return cluster;
    }

    public DiffType getType() {
        return diffType;
    }

    @Override
    public Option<IndexedCluster> getClusterUpdate() {
        return Option.empty();
    }

    public static EntireClusterDiff clusterAdded(IndexedCluster cluster) {
        return new EntireClusterDiff(cluster, DiffType.ADD);
    }

    public static EntireClusterDiff clusterRemoved(IndexedCluster cluster) {
        return new EntireClusterDiff(cluster, DiffType.REMOVE);
    }

    @Override
    public EntireClusterDiff addGeoData(Function<IndexedCluster, IndexedCluster> withGeobaseData) {
        if (getType() == DiffType.REMOVE) {
            return this; //Should be loaded and not needed anyway
        }
        return new EntireClusterDiff(withGeobaseData.apply(getCluster()), getType());
    }

    @Override
    public EntireClusterDiff withCluster(IndexedCluster cluster) {
        return new EntireClusterDiff(cluster, diffType);
    }
}
