package ru.yandex.chemodan.app.smartcache.worker.processing.clusterMatching.diffs;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.app.smartcache.worker.clusterizer.pojo.PhotoViewLuceneClusterPojo;
import ru.yandex.chemodan.app.smartcache.worker.dataapi.IndexedCluster;
import ru.yandex.chemodan.app.smartcache.worker.processing.clusterMatching.ClusterDiff;
import ru.yandex.chemodan.app.smartcache.worker.utils.PojoConverters;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author osidorkin
 */
public final class MatchedClustersDiff extends DefaultObject implements ClusterDiff {

    private final DiffType diffType;
    private final int matchedPhotosCount;
    private final IndexedCluster cluster;
    private final IndexedCluster newCluster;

    private MatchedClustersDiff(IndexedCluster cluster, PhotoViewLuceneClusterPojo clusterPojo, DiffType diffType, int matchedPhotosCount) {
        this(cluster, buildNewCluster(clusterPojo, cluster), diffType, matchedPhotosCount);
    }

    private MatchedClustersDiff(IndexedCluster cluster, IndexedCluster newCluster,
            DiffType diffType, int matchedPhotosCount)
    {
        this.cluster = cluster;
        this.diffType = diffType;
        this.matchedPhotosCount = matchedPhotosCount;
        this.newCluster = newCluster;
    }

    public IndexedCluster getCluster() {
        return cluster;
    }

    public IndexedCluster getNewCluster() {
        return newCluster;
    }

    public DiffType getType() {
        return diffType;
    }

    @Override
    public Option<IndexedCluster> getClusterUpdate() {
        return Option.of(newCluster);
    }

    private static IndexedCluster buildNewCluster(PhotoViewLuceneClusterPojo clusterPojo, IndexedCluster oldCluster) {
        return PojoConverters.buildClustersIndex(oldCluster.getId().getFormat(), clusterPojo)
            .withGeoPlaces(oldCluster.getPlaces())
            .withGeoLocality(oldCluster.getLocalityO());
    }

    public static MatchedClustersDiff majorityMatch(IndexedCluster cluster, PhotoViewLuceneClusterPojo clusterPojo,
            int matchedPhotosCount)
    {
        return new MatchedClustersDiff(cluster, clusterPojo, DiffType.MAJORITY_MATCH, matchedPhotosCount);
    }

    public static MatchedClustersDiff majorityMatch(IndexedCluster cluster, IndexedCluster newCluster,
            int matchedPhotosCount)
    {
        return new MatchedClustersDiff(cluster, newCluster, DiffType.MAJORITY_MATCH, matchedPhotosCount);
    }

    public static MatchedClustersDiff exactMatch(IndexedCluster cluster, PhotoViewLuceneClusterPojo clusterPojo, int matchedPhotosCount) {
        return new MatchedClustersDiff(cluster, clusterPojo, DiffType.EXACT_MATCH, matchedPhotosCount);
    }

    @Override
    public MatchedClustersDiff addGeoData(Function<IndexedCluster, IndexedCluster> withGeobaseData) {
        if (getType() == DiffType.EXACT_MATCH) {
            return this; //Already loaded
        }
        return majorityMatch(getCluster(), withGeobaseData.apply(getNewCluster()), matchedPhotosCount);
    }

    @Override
    public MatchedClustersDiff withCluster(IndexedCluster cluster) {
        return new MatchedClustersDiff(cluster, newCluster, diffType, matchedPhotosCount);
    }
}
