package ru.yandex.chemodan.app.smartcache.worker.processing.tasks;

import org.joda.time.Duration;

import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author dbrylev
 */
@BenderBindAllFields
public class BlockerTaskParameters {
    public final DataApiUserId uid;
    public final Duration delay;

    public BlockerTaskParameters(DataApiUserId uid, Duration delay) {
        this.uid = uid;
        this.delay = delay;
    }

    public static class ActiveUidConverter extends PhotosliceUserParameters.ConverterFrom<BlockerTaskParameters> {
        public ActiveUidConverter() {
            super(p -> p.uid);
        }
    }
}
