package ru.yandex.chemodan.app.smartcache.worker.processing.tasks;

import org.joda.time.Duration;

import ru.yandex.chemodan.app.smartcache.worker.SmartCacheTaskQueueName;
import ru.yandex.chemodan.app.smartcache.worker.dataapi.cleanup.CleanupManager;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;

/**
 * @author friendlyevil
 */
public class DeleteDeltaTask extends OnetimeTaskSupport<DeleteDeltaParameters> {
    private CleanupManager cleanupManager;

    public DeleteDeltaTask(CleanupManager cleanupManager) {
        super(DeleteDeltaParameters.class);
        this.cleanupManager = cleanupManager;
    }

    public DeleteDeltaTask(DeleteDeltaParameters parameters) {
        super(parameters);
    }

    @Override
    protected void execute(DeleteDeltaParameters parameters, ExecutionContext context) throws Exception {
        cleanupManager.removeExpiredDelta(parameters.uid, parameters.handle);
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(3);
    }

    @Override
    public TaskQueueName queueName() {
        return SmartCacheTaskQueueName.SMARTCACHE_CLEANUP;
    }
}
