package ru.yandex.chemodan.app.smartcache.worker.processing.tasks;

import org.joda.time.Duration;

import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.smartcache.worker.SmartCacheTaskQueueName;
import ru.yandex.chemodan.app.smartcache.worker.processing.PhotosliceProcessingManager;
import ru.yandex.chemodan.app.smartcache.worker.processing.PhotosliceTransitionManager;
import ru.yandex.chemodan.app.smartcache.worker.utils.SmartCacheOnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.ActiveUidBehavior;
import ru.yandex.commune.bazinga.scheduler.ActiveUidDropType;
import ru.yandex.commune.bazinga.scheduler.ActiveUidDuplicateBehavior;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.misc.thread.ThreadUtils;

/**
 * @author yashunsky
 */
public class InitAlbumsTask extends SmartCacheOnetimeTaskSupport<PhotosliceUserParameters> {


    private PhotosliceTransitionManager photosliceTransitionManager;
    private PhotosliceProcessingManager photosliceProcessingManager;

    public InitAlbumsTask(PhotosliceTransitionManager photosliceTransitionManager,
            PhotosliceProcessingManager photosliceProcessingManager)
    {
        super(PhotosliceUserParameters.class);
        this.photosliceTransitionManager = photosliceTransitionManager;
        this.photosliceProcessingManager = photosliceProcessingManager;
    }

    public InitAlbumsTask(DataApiUserId uid) {
        super(new PhotosliceUserParameters(uid));
    }
    @Override
    protected void execute(PhotosliceUserParameters parameters, ExecutionContext context) throws Exception {
        ThreadUtils.sleep(photosliceTransitionManager.getSleepTime(parameters.uid));
        photosliceTransitionManager.initAlbums(parameters.uid, photosliceProcessingManager);
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public TaskQueueName queueName() {
        return SmartCacheTaskQueueName.SMARTCACHE_INIT_ALBUMS;
    }

    @Override
    public ActiveUidBehavior activeUidBehavior() {
        return new ActiveUidBehavior(ActiveUidDropType.WHEN_FINISHED, ActiveUidDuplicateBehavior.DO_NOTHING);
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(5);
    }
}
