package ru.yandex.chemodan.app.smartcache.worker.processing.tasks;

import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.commune.bazinga.scheduler.ActiveUniqueIdentifierConverter;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author dbrylev
 */
@BenderBindAllFields
public class PhotosliceUserParameters {
    public final DataApiUserId uid;

    public PhotosliceUserParameters(DataApiUserId uid) {
        this.uid = uid;
    }

    public static abstract class ConverterFrom<P>
            implements ActiveUniqueIdentifierConverter<P, PhotosliceUserParameters>
    {
        private final Function<P, DataApiUserId> getUid;

        public ConverterFrom(Function<P, DataApiUserId> getUid) {
            this.getUid = getUid;
        }

        @Override
        public Class<PhotosliceUserParameters> getActiveUniqueIdentifierClass() {
            return PhotosliceUserParameters.class;
        }

        @Override
        public PhotosliceUserParameters convert(P parameters) {
            return new PhotosliceUserParameters(getUid.apply(parameters));
        }
    }
}
