package ru.yandex.chemodan.app.smartcache.worker.processing.tasks;

import org.joda.time.Duration;

import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.smartcache.worker.processing.PhotosliceProcessingManager;
import ru.yandex.chemodan.app.smartcache.worker.utils.SmartCacheOnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;

/**
 * @author osidorkin
 */
public class UpdateClusterPlacesTask extends SmartCacheOnetimeTaskSupport<PhotosliceClusterParameters> {

    private PhotosliceProcessingManager photosliceProcessingManager;

    public UpdateClusterPlacesTask(PhotosliceProcessingManager photosliceProcessingManager) {
        super(PhotosliceClusterParameters.class);
        this.photosliceProcessingManager = photosliceProcessingManager;
    }

    public UpdateClusterPlacesTask(DataApiUserId uid, String handle, String clusterId) {
        super(new PhotosliceClusterParameters(uid, handle, clusterId));
    }

    @Override
    protected void execute(PhotosliceClusterParameters parameters, ExecutionContext context) throws Exception {
        photosliceProcessingManager.updateClusterPlaces(parameters.uid, parameters.handle, parameters.clusterId);
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(5);
    }
}
