package ru.yandex.chemodan.app.smartcache.worker.processing.tasks;

import javax.annotation.Nullable;

import org.joda.time.Duration;

import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.smartcache.worker.SmartCacheTaskQueueName;
import ru.yandex.chemodan.app.smartcache.worker.utils.SmartCacheOnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.ActiveUniqueIdentifierConverter;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.commune.bazinga.scheduler.schedule.RescheduleNever;
import ru.yandex.commune.bazinga.scheduler.schedule.ReschedulePolicy;

/**
 * @author dbrylev
 */
public class UpdatePhotosliceBlockerTask extends SmartCacheOnetimeTaskSupport<BlockerTaskParameters> {

    public UpdatePhotosliceBlockerTask(DataApiUserId uid, Duration delay) {
        super(new BlockerTaskParameters(uid, delay));
    }

    public UpdatePhotosliceBlockerTask() {
        super(BlockerTaskParameters.class);
    }

    @Override
    protected void execute(BlockerTaskParameters parameters, ExecutionContext context) throws Exception {
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(1);
    }

    @Override
    public ReschedulePolicy reschedulePolicy() {
        return new RescheduleNever();
    }

    @Override
    public TaskQueueName queueName() {
        return SmartCacheTaskQueueName.SMARTCACHE_PHOTOSLICE_UPDATE_LIMITERS;
    }

    @Override
    public int priority() {
        return 0;
    }

    @Nullable
    @Override
    public Class<? extends ActiveUniqueIdentifierConverter<?, ?>> getActiveUidConverter() {
        return BlockerTaskParameters.ActiveUidConverter.class;
    }
}
