package ru.yandex.chemodan.app.smartcache.worker.processing.tasks;

import javax.annotation.Nullable;

import org.joda.time.Duration;
import org.joda.time.Instant;

import ru.yandex.chemodan.app.smartcache.worker.SmartCacheTaskQueueName;
import ru.yandex.chemodan.app.smartcache.worker.utils.DynamicVars;
import ru.yandex.chemodan.app.smartcache.worker.utils.SmartCacheOnetimeTaskSupport;
import ru.yandex.chemodan.bazinga.PgOnetimeUtils;
import ru.yandex.commune.bazinga.impl.FullJobId;
import ru.yandex.commune.bazinga.impl.OnetimeJob;
import ru.yandex.commune.bazinga.pg.storage.PgBazingaStorage;
import ru.yandex.commune.bazinga.scheduler.ActiveUidBehavior;
import ru.yandex.commune.bazinga.scheduler.ActiveUidDropType;
import ru.yandex.commune.bazinga.scheduler.ActiveUidDuplicateBehavior;
import ru.yandex.commune.bazinga.scheduler.ActiveUniqueIdentifierConverter;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.commune.bazinga.scheduler.schedule.CompoundReschedulePolicy;
import ru.yandex.commune.bazinga.scheduler.schedule.RescheduleConstant;
import ru.yandex.commune.bazinga.scheduler.schedule.RescheduleExponential;
import ru.yandex.commune.bazinga.scheduler.schedule.ReschedulePolicy;

/**
 * @author dbrylev
 */
public class UpdatePhotosliceSubmitterTask extends SmartCacheOnetimeTaskSupport<UpdaterTaskParameters> {

    private final PgBazingaStorage bazingaStorage;

    public UpdatePhotosliceSubmitterTask(UpdaterTaskParameters params) {
        super(params);
        this.bazingaStorage = null;
    }

    public UpdatePhotosliceSubmitterTask(PgBazingaStorage bazingaStorage) {
        super(UpdaterTaskParameters.class);
        this.bazingaStorage = bazingaStorage;
    }

    public UpdatePhotosliceSubmitterTask withParsedParameters(String params) {
        return new UpdatePhotosliceSubmitterTask(PgOnetimeUtils.parseParameters(this, params));
    }

    @Override
    protected void execute(UpdaterTaskParameters parameters, ExecutionContext context) throws Exception {
        OnetimeJob updater = PgOnetimeUtils.makeJob(new UpdatePhotosliceTask(parameters), Instant.now());
        FullJobId addedId = bazingaStorage.addOnetimeJob(updater, ActiveUidDuplicateBehavior.DO_NOTHING);

        if (addedId.getJobId().equals(updater.getJobId())) {
            Duration delay = DynamicVars.photosliceUpdateDelay.get();

            OnetimeJob limiter = PgOnetimeUtils.makeJob(
                    new UpdatePhotosliceBlockerTask(parameters.uid, delay), Instant.now().plus(delay));

            bazingaStorage.addOnetimeJob(limiter, ActiveUidDuplicateBehavior.MERGE);

        } else {
            throw new RuntimeException("Snapshot is still updating for user " + parameters.uid);
        }
    }

    @Override
    public ActiveUidBehavior activeUidBehavior() {
        return new ActiveUidBehavior(ActiveUidDropType.WHEN_RUNNING, ActiveUidDuplicateBehavior.DO_NOTHING);
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(1);
    }

    @Override
    public ReschedulePolicy reschedulePolicy() {
        return new CompoundReschedulePolicy(
                new RescheduleConstant(Duration.standardSeconds(20), 10),
                new RescheduleExponential(Duration.standardMinutes(1), 10));
    }

    @Override
    public TaskQueueName queueName() {
        return SmartCacheTaskQueueName.SMARTCACHE_PHOTOSLICE_UPDATE_LIMITERS;
    }

    @Override
    public int priority() {
        return 0;
    }

    @Nullable
    @Override
    public Class<? extends ActiveUniqueIdentifierConverter<?, ?>> getActiveUidConverter() {
        return UpdaterTaskParameters.ActiveUidConverter.class;
    }
}
