package ru.yandex.chemodan.app.smartcache.worker.processing.tasks;

import javax.annotation.Nullable;

import org.joda.time.Duration;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.app.smartcache.worker.SmartCacheTaskQueueName;
import ru.yandex.chemodan.app.smartcache.worker.processing.PhotosliceProcessingManager;
import ru.yandex.chemodan.app.smartcache.worker.utils.SmartCacheOnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.ActiveUidBehavior;
import ru.yandex.commune.bazinga.scheduler.ActiveUidDropType;
import ru.yandex.commune.bazinga.scheduler.ActiveUidDuplicateBehavior;
import ru.yandex.commune.bazinga.scheduler.ActiveUniqueIdentifierConverter;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.commune.bazinga.scheduler.schedule.RescheduleExponential;
import ru.yandex.commune.bazinga.scheduler.schedule.ReschedulePolicy;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author dbrylev
 */
public class UpdatePhotosliceTask extends SmartCacheOnetimeTaskSupport<UpdaterTaskParameters> {

    private static final Logger logger = LoggerFactory.getLogger(UpdatePhotosliceTask.class);

    private final PhotosliceProcessingManager photosliceProcessingManager;

    public UpdatePhotosliceTask(UpdaterTaskParameters params) {
        super(params);
        this.photosliceProcessingManager = null;
    }

    public UpdatePhotosliceTask(PhotosliceProcessingManager photosliceProcessingManager) {
        super(UpdaterTaskParameters.class);
        this.photosliceProcessingManager = photosliceProcessingManager;
    }

    @Override
    protected void execute(UpdaterTaskParameters parameters, ExecutionContext context) throws Exception {
        photosliceProcessingManager.updateSnapshot(parameters.uid, false);

        Function<Option<Instant>, Object> formatTs = ts -> ts.<Object>map(Instant::getMillis).getOrElse("");

        logger.info("Photoslice updated successfully: uid={}, timestamp={}, accepted={}, completed={}",
                parameters.uid, formatTs.apply(parameters.timestamp),
                formatTs.apply(parameters.acceptTime),
                formatTs.apply(Option.of(Instant.now())));
    }

    @Override
    public ActiveUidBehavior activeUidBehavior() {
        return new ActiveUidBehavior(ActiveUidDropType.WHEN_FINISHED, ActiveUidDuplicateBehavior.MERGE_IF_READY);
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(10);
    }

    @Override
    public ReschedulePolicy reschedulePolicy() {
        return new RescheduleExponential(Duration.standardSeconds(10), 5);
    }

    @Override
    public TaskQueueName queueName() {
        return SmartCacheTaskQueueName.SMARTCACHE_PHOTOSLICE_UPDATE;
    }

    @Override
    public int priority() {
        return 0;
    }

    @Nullable
    @Override
    public Class<? extends ActiveUniqueIdentifierConverter<?, ?>> getActiveUidConverter() {
        return UpdaterTaskParameters.ActiveUidConverter.class;
    }
}
