package ru.yandex.chemodan.app.smartcache.worker.processing.tasks;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author dbrylev
 */
@BenderBindAllFields
public class UpdaterTaskParameters {
    public final DataApiUserId uid;
    public final Option<Instant> timestamp;
    public final Option<Instant> acceptTime;

    public UpdaterTaskParameters(DataApiUserId uid, Option<Instant> timestamp, Option<Instant> acceptTime) {
        this.uid = uid;
        this.timestamp = timestamp;
        this.acceptTime = acceptTime;
    }

    public static class ActiveUidConverter extends PhotosliceUserParameters.ConverterFrom<UpdaterTaskParameters> {
        public ActiveUidConverter() {
            super(p -> p.uid);
        }
    }
}
