package ru.yandex.chemodan.app.smartcache.worker.utils;

import java.util.function.Supplier;

import org.joda.time.Duration;
import org.joda.time.LocalTime;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.commune.dynproperties.DynamicProperty;

/**
 * @author osidorkin
 */
public class DynamicVars {

    public static final DynamicProperty<String> clusterizerExtraParams = DynamicProperty.cons("clusterizerExtraParams", "");
    public static final DynamicProperty<Integer> photoslicePlacesNum = DynamicProperty.cons("photoslicePlacesNum", 10);
    public static final DynamicProperty<Integer> photosliceDeltaExpirationDays =
            DynamicProperty.cons("photosliceDeltaExpirationDays", 30);
    public static final DynamicProperty<Integer> placesUpdateTasksPerWindow =
            DynamicProperty.cons("placesUpdateTasksPerWindow", 100);
    public static final DynamicProperty<Integer> placesUpdateWindowMultiplier =
            DynamicProperty.cons("placesUpdateWindowMultiplier", 2);
    public static final DynamicProperty<Integer> geocoderRPSMax =
            DynamicProperty.cons("geocoderRPSMax", 3000);
    public static final DynamicProperty<ListF<String>> shortenNamesPatterns =
            DynamicProperty.cons("geocoder-shorten-names-patterns", Cf.list());

    public static final DynamicProperty<Integer> photosliceUpdateDelaySeconds =
            DynamicProperty.cons("photosliceUpdateDelay", 2 * 60);
    public static final Supplier<Duration> photosliceUpdateDelay =
            () -> Duration.standardSeconds(photosliceUpdateDelaySeconds.get());

    public static final DynamicProperty<Boolean> preferDeltasFromMaster =
            DynamicProperty.cons("preferDeltasFromMaster", true);

    public static final DynamicProperty<Integer> photoCountLimit =
            new DynamicProperty<>("photoslice-photos-limit", 300000);

    public static final DynamicProperty<Boolean> photosliceCreateWithAlbums =
            DynamicProperty.cons("photosliceCreateWithAlbums", false);

    public static final DynamicProperty<Boolean> useMpfsAlbumsFlag =
            DynamicProperty.cons("photosliceUseMpfsAlbumsFlag", false);

    public static final DynamicProperty<Integer> albumsInitDelayMs =
            DynamicProperty.cons("albumsInitDelay", 1000);
    public static final DynamicProperty<ListF<String>> albumsInitDelayMsByShard =
            DynamicProperty.cons("albumsInitDelayByShard", Cf.list());
    public static final DynamicProperty<Integer> updateSnapshotDiffBatchSize =
            DynamicProperty.cons("updateSnapshotDiffBatchSize", 100);

    public static final DynamicProperty<Integer> cleaningMongoBatchSize =
            DynamicProperty.cons("cleaning-mongo-batch-size", 1000);
    public static final DynamicProperty<Integer> cleaningMinQueueSize =
            DynamicProperty.cons("cleaning-min-task-queue-size", 1000);
    public static final DynamicProperty<Integer> cleaningMaxQueueSize =
            DynamicProperty.cons("cleaning-max-task-queue-size", 100000);

    public static final DynamicProperty<Boolean> parallelRemoveExpiredSnapshot =
            new DynamicProperty<>("smartcache-remove-expired-snapshot-enable", false);
    public static final DynamicProperty<LocalTime> allowRemovingExpiredSnapshotAfter =
            new DynamicProperty<>("smartcache-remove-expired-snapshot-allow-after",
                    new LocalTime(0, 0));
    public static final DynamicProperty<LocalTime> allowRemovingExpiredSnapshotBefore =
            new DynamicProperty<>("smartcache-remove-expired-snapshot-allow-before",
                    new LocalTime(23, 59, 59));
    public static final DynamicProperty<Boolean> useCleaningOnOnetimeTasks =
            new DynamicProperty<>("smartcache-remove-expired-use-onetime-tasks", false);
}
