package ru.yandex.chemodan.app.smartcache.worker.utils;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.smartcache.worker.utils.ListDiffCalculator.Diff;
import ru.yandex.misc.test.Assert;

/**
 * @author osidorkin
 */
public class ListDiffCalculatorTest {

    @Test
    public void testListDiff() {
        ListF<Character> oldList = Cf.list('a', 'b', 'a', 'c', 'a', 'b', 'a');
        ListF<Character> newList = Cf.list('a', 'b', 'a', 'd', 'a', 'b', 'a');

        runTest(oldList, newList, 1);
    }

    @Test
    public void testListDiff2() {
        ListF<Character> oldList = Cf.list('b', 'a', 'c', 'a', 'b', 'a');
        ListF<Character> newList = Cf.list('a', 'b', 'a', 'd', 'a', 'b');

        runTest(oldList, newList, 3);
    }

    @Test
    public void testListDiff3() {
        ListF<Character> oldList = Cf.list('b');
        ListF<Character> newList = Cf.list('a', 'b');

        runTest(oldList, newList, 1);
    }

    @Test
    public void testEmptyListDiff() {
        ListF<Character> oldList = Cf.list('a', 'b', 'a', 'c', 'a', 'b', 'a');
        ListF<Character> newList = Cf.list();

        runTest(oldList, newList, oldList.size());
    }

    @Test
    public void testEmptyListDiff2() {
        ListF<Character> newList = Cf.list('a', 'b', 'a', 'c', 'a', 'b', 'a');
        ListF<Character> oldList = Cf.list();

        runTest(oldList, newList, newList.size());
    }

    @Test
    public void testEqualListDiff() {
        ListF<Character> oldList = Cf.list('a', 'b', 'a', 'c', 'a', 'b', 'a');
        ListF<Character> newList = oldList;
        runTest(oldList, newList, 0);
    }

    @Test
    public void testLargeDiff() {
        ListF<Character> oldList = Cf.list('a', 'b', 'c', 'd');
        ListF<Character> newList = Cf.list('e', 'f', 'g', 'h');

        runTest(oldList, newList, 4);
    }

    @Test
    public void testLargeDiff2() {
        ListF<Character> oldList = Cf.list('a', 'b', 'c', 'd');
        ListF<Character> newList = Cf.list('e', 'f', 'g', 'h', 'i', 'j', 'k');

        runTest(oldList, newList, 7);
    }

    @Test
    public void testLargeDiff3() {
        ListF<Character> oldList = Cf.list('a', 'b', 'c', 'd', 'e', 'f', 'g');
        ListF<Character> newList = Cf.list('h', 'i', 'j', 'k');

        runTest(oldList, newList, 7);
    }

    @Test
    public void testPlaces() {
        ListF<Character> oldList = Cf.list('1', '4', '6');
        ListF<Character> newList = Cf.list('0', '1', '2', '3');
        runTest(oldList, newList, 3);
        runTest(newList, oldList, 3);
    }

    @Test
    public void testRebulus() {
        ListF<Character> oldList = Cf.list('A', 'B', 'C', 'D');
        ListF<Character> newList = Cf.list('A', 'E', 'B', 'C', 'F', 'D');
        runTest(oldList, newList, 2);
        runTest(newList, oldList, 2);
    }

    private static <T> void runTest(ListF<T> oldList, ListF<T> newList, int diffSize) {
        ListF<Diff<T>> list = ListDiffCalculator.calculateDifference(oldList, newList);
        Assert.sizeIs(diffSize, list);
        ListF<T> applied =  ListDiffCalculator.applyDiff(oldList, list);
        Assert.assertListsEqual(newList, applied);
    }
}
