package ru.yandex.chemodan.app.smartcache.worker.utils;


import org.joda.time.Instant;

import ru.yandex.chemodan.app.dataapi.DataApiBenderUtils;
import ru.yandex.chemodan.app.smartcache.worker.utils.marshallers.UnixTimestampInstantMarshaller;
import ru.yandex.chemodan.app.smartcache.worker.utils.marshallers.UnixTimestampInstantUnmarshaller;
import ru.yandex.inside.utils.Language;
import ru.yandex.misc.bender.BenderMapper;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.config.BenderConfiguration;
import ru.yandex.misc.bender.config.BenderSettings;
import ru.yandex.misc.bender.config.CustomMarshallerUnmarshallerFactory;
import ru.yandex.misc.bender.config.CustomMarshallerUnmarshallerFactoryBuilder;
import ru.yandex.misc.bender.custom.StringEnumByValueMarshaller;
import ru.yandex.misc.bender.custom.StringEnumByValueUnmarshaller;

/**
 * @author osidorkin
 */
public class PhotoViewCacheBender {

    private static final BenderConfiguration clientA3BenderConfiguration = createBenderClientA3Configuration();

    private static final BenderMapper searchMapper = createSearchMapper();
    private static final BenderMapper clientA3Mapper = createClientA3Mapper();

    private static BenderConfiguration createBenderSearchConfiguration() {
        BenderSettings settings = new BenderSettings(MembersToBind.ALL_FIELDS, true);
        return new BenderConfiguration(settings, searchMarshallerUnmarshallerFactory());
    }

    private static CustomMarshallerUnmarshallerFactory searchMarshallerUnmarshallerFactory() {
        return CustomMarshallerUnmarshallerFactoryBuilder.cons()
                .add(Instant.class, new UnixTimestampInstantMarshaller(), new UnixTimestampInstantUnmarshaller())
                .build();
    }

    private static BenderConfiguration createBenderClientA3Configuration() {
        return new BenderConfiguration(new BenderSettings(), clientA3MarshallerUnmarshallerFactory());
    }

    private static CustomMarshallerUnmarshallerFactory clientA3MarshallerUnmarshallerFactory() {
        return DataApiBenderUtils.marshallerUnmarshallerFactoryBuilder()
                .add(Language.class, new StringEnumByValueMarshaller<Language>(),
                        new StringEnumByValueUnmarshaller<Language>(Language.R))
                .build();
    }

    private static BenderMapper createSearchMapper() {
        return new BenderMapper(createBenderSearchConfiguration());
    }

    private static BenderMapper createClientA3Mapper() {
        return new BenderMapper(clientA3BenderConfiguration);
    }

    public static BenderMapper searchMapper() {
        return searchMapper;
    }

    public static BenderMapper clientA3Mapper() {
        return clientA3Mapper;
    }

    public static BenderConfiguration clientA3BenderConfiguration() {
        return clientA3BenderConfiguration;
    }
}
