package ru.yandex.chemodan.app.smartcache.worker.utils;


import java.util.Collections;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.bolts.function.Function;
import ru.yandex.misc.lang.ObjectUtils;

/**
 * @author osidorkin
 */
public class SortedSplitter {

    public static <K, V> Tuple2List<K, ListF<V>> splitCollections(ListF<V> items, Function<V, K> mapper) {
        if (items.isEmpty()) {
            return Tuple2List.tuple2List();
        }

        int firstChunkStartIdx = 0;
        Tuple2List<K, ListF<V>> res = Tuple2List.arrayList();
        do {
            V firstItem = items.get(firstChunkStartIdx);
            int nextCollectionStartIdx = -Collections.binarySearch(items.subList(firstChunkStartIdx, items.size()), firstItem,
                    (V a, V b) -> { return mapper.apply(a).equals(mapper.apply(b)) ? -1 : 1; }
                    );
            int collectionEnd = firstChunkStartIdx + nextCollectionStartIdx - 1;
            res.add(mapper.apply(firstItem), items.subList(firstChunkStartIdx, collectionEnd));
            firstChunkStartIdx = collectionEnd;
        } while (firstChunkStartIdx != items.size());
        return res;
    }

    public static <V, E> MapF<V, ListF<E>> sortedGroupBy(ListF<E> list, Function<? super E, ? extends V> mapper) {
        if (list.isEmpty()) {
            return Cf.map();
        }

        V startKey = mapper.apply(list.first());
        if (list.size() == 1) {
            return Cf.map(startKey, list);
        }

        MapF<V, ListF<E>> res = Cf.hashMap();
        int startIndex = 0;
        for (int currentIndex = 1; currentIndex < list.size(); currentIndex++) {
            V currentKey = mapper.apply(list.get(currentIndex));
            if (!ObjectUtils.equalsTu(startKey, currentKey)) {
                res.put(startKey, list.subList(startIndex, currentIndex));
                startIndex = currentIndex;
                startKey = currentKey;
            }
        }
        res.put(startKey, list.subList(startIndex, list.size()));
        return res;
    }
}
