package ru.yandex.chemodan.app.smartcache.worker.utils;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.bolts.function.Function;
import ru.yandex.misc.test.Assert;

/**
 * @author osidorkin
 */
public class SortedSplitterTest {

    @Test
    public void testEmpty() {
        Assert.isEmpty(SortedSplitter.splitCollections(Cf.<Integer>list(), Function.identityF()));
    }

    @Test
    public void testSingle() {
        Assert.equals(Tuple2List.fromPairs(1, Cf.<Integer>list(1)),
                SortedSplitter.splitCollections(Cf.<Integer>list(1), Function.identityF()));
        Assert.equals(Tuple2List.fromPairs(1, Cf.<Integer>list(1, 1)),
                SortedSplitter.splitCollections(Cf.<Integer>list(1, 1), Function.identityF()));
    }

    @Test
    public void testMultiple() {
        Assert.equals(Tuple2List.fromPairs(1, Cf.<Integer>list(1), 2, Cf.<Integer>list(2)),
                SortedSplitter.splitCollections(Cf.<Integer>list(1, 2), Function.identityF()));
        Assert.equals(Tuple2List.fromPairs(1, Cf.<Integer>list(1, 1), 2, Cf.<Integer>list(2, 2)),
                SortedSplitter.splitCollections(Cf.<Integer>list(1, 1, 2, 2), Function.identityF()));
    }

    @Test
    public void testSortegGroupBy() {
        groupByTest(Cf.list(), Function.identityF());
        groupByTest(Cf.list("A"), Function.identityF());
        groupByTest(Cf.list("A", "A"), Function.identityF());
        groupByTest(Cf.list("A", "A", "B", "B"), Function.identityF());
        groupByTest(Cf.list("B", "B", "A", "A"), Function.identityF());
        groupByTest(Cf.list("A", "A", "B", "B", "C"), Function.identityF());
        groupByTest(Cf.list("A", "A", "B", "B", "C", "D"), Function.identityF());

    }

    private static <A, B> void groupByTest(ListF<B> list, Function<B, A> mapper) {
        Assert.equals(list.groupBy(mapper),
                SortedSplitter.sortedGroupBy(list, mapper));
    }
}
