package ru.yandex.chemodan.app.smartcache.worker.utils;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.db.q.SqlLimits;

/**
 * @author osidorkin
 */
public class SqlLimitsHelper {

    public static SqlLimits getLimits(Option<Integer> limitO, Option<Integer> offsetO) {
        if (limitO.isPresent()) {
            return SqlLimits.range(offsetO.getOrElse(0), limitO.get());
        }
        if (offsetO.isPresent()) {
            return SqlLimits.range(offsetO.get(), Integer.MAX_VALUE); //Offset only syntax is postgresql-only
        }
        return SqlLimits.all();
    }
}
