package ru.yandex.chemodan.app.smartcache.worker.utils;

import org.junit.Test;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.db.q.SqlLimits;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class SqlLimitsHelperTest {
    @Test
    public void shouldUseBothValuesWhenBothSpecified() {
        Assert.equals(
                SqlLimits.range(77, 123),
                SqlLimitsHelper.getLimits(Option.of(123), Option.of(77))
        );
    }

    @Test
    public void shouldUseLimitAndZeroIfOnlyLimitSpecified() {
        Assert.equals(
                SqlLimits.range(0, 16),
                SqlLimitsHelper.getLimits(Option.of(16), Option.empty())
        );
    }

    @Test
    public void shouldUseOffsetAndIntegerMaxValueIfOnlyOffsetSpecified() {
        Assert.equals(
                SqlLimits.range(83, Integer.MAX_VALUE),
                SqlLimitsHelper.getLimits(Option.empty(), Option.of(83))
        );
    }

    @Test
    public void shouldReturnAllIfNoneSpecified() {
        Assert.equals(SqlLimits.all(), SqlLimitsHelper.getLimits(Option.empty(), Option.empty()));
    }
}
