package ru.yandex.chemodan.app.smartcache.worker.utils;

import java.util.stream.Stream;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.bolts.function.forhuman.Comparator;

/**
 * @author osidorkin
 */
public class TopNSelector {

    public static <T> ListF<T> getTopNItems(Stream<T> values, Comparator<T> valuesComparator, int amount) {
        Comparator<Tuple2<T, Integer>> c =
                Tuple2.<T, Integer>get2F().andThenNaturalComparator().invert()
                .chainTo(Tuple2.<T, Integer>get1F().andThen(valuesComparator));
        return countUniqueValues(values).mapEntries(Tuple2::tuple).takeSorted(c, amount)
            .map(Tuple2.<T, Integer>get1F());
    }

    public static <T> MapF<T, Integer> countUniqueValues(Stream<T> values) {
        MapF<T, Integer> res = Cf.hashMap();
        values.forEach(value -> res.compute(value, (l, v)-> { return v == null ? 1 : v + 1; }));
        return res;
    }
}
