package ru.yandex.chemodan.app.smartcache.worker.utils;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.forhuman.Comparator;
import ru.yandex.misc.test.Assert;

/**
 * @author osidorkin
 */
public class TopNSelectorTest {

    @Test
    public void countUniqueValues() {
        Assert.equals(Cf.map(), TopNSelector.countUniqueValues(Cf.list().stream()));
        Assert.equals(Cf.map(1, 1), TopNSelector.countUniqueValues(Cf.list(1).stream()));
        Assert.equals(Cf.map(Cf.list(1, 2, 3).zipWith(a -> { return 1; }).toList()),
                TopNSelector.countUniqueValues(Cf.list(1, 2, 3).stream()));
        Assert.equals(Cf.map(1, 2), TopNSelector.countUniqueValues(Cf.list(1, 1).stream()));
        Assert.equals(Cf.map(1, 2, 2, 1), TopNSelector.countUniqueValues(Cf.list(1, 1, 2).stream()));
    }

    @Test
    public void getTopNItems() {
        assertIntegerLists(Cf.list(1), Cf.list(1), 10);
        assertIntegerLists(Cf.list(1), Cf.list(1, 1), 10);
        assertIntegerLists(Cf.list(1), Cf.list(1, 1, 1), 10);
        assertIntegerLists(Cf.list(1, 2), Cf.list(1, 1, 2), 10);
        assertIntegerLists(Cf.list(1, 2, 3, 4), Cf.list(1, 1, 2, 3, 4), 10);
        assertIntegerLists(Cf.list(1, 2), Cf.list(1, 1, 2, 3, 4), 2);
    }

    private static void assertIntegerLists(ListF<Integer> expected, ListF<Integer> raw, int amount) {
        Assert.equals(expected, TopNSelector.getTopNItems(raw.stream(), Comparator.naturalComparator(), amount));
    }
}
