package ru.yandex.chemodan.app.smartcache.worker.utils.marshallers;

import org.joda.time.Instant;

import ru.yandex.misc.bender.serialize.BenderJsonWriter;
import ru.yandex.misc.bender.serialize.simpleType.SimpleTypeMarshallerSupport;

public class UnixTimestampInstantMarshaller extends SimpleTypeMarshallerSupport {

    @Override
    protected String toStringValueForXml(Object o) {
        long seconds = getSeconds(o);
        return Long.toString(seconds);
    }

    @Override
    protected void writeJson(BenderJsonWriter json, Object o) {
        json.writeNumber(getSeconds(o));
    }

    private long getSeconds(Object o) {
        return ((Instant) o).getMillis() / 1000L;
    }
}
