package ru.yandex.chemodan.app.smartcache.worker.utils.marshallers;

import org.joda.time.Instant;
import org.w3c.dom.Node;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.parse.BenderJsonNode;
import ru.yandex.misc.bender.parse.FieldLevelUnmarshaller;
import ru.yandex.misc.bender.parse.ParseResult;
import ru.yandex.misc.bender.parse.UnmarshallerContext;
import ru.yandex.misc.lang.Validate;

/**
 * @author osidorkin
 */
public class UnixTimestampInstantUnmarshaller implements FieldLevelUnmarshaller {

    private ParseResult<Object> parseAndConvert(String value) {
        try {
            Option<Long> millis = Cf.Long.parseSafe(value);
            Validate.some(millis);
            Instant instant = fromSeconds(millis.get());
            return ParseResult.<Object>result(instant);
        } catch (Exception e) {
            return ParseResult.failure("Failed to parse '" + value + "' as Instant: " + e);
        }
    }

    private Instant fromSeconds(long seconds) {
        return new Instant(seconds * 1000L);
    }

    @Override
    public ParseResult<Object> parseXmlNode(Node node, UnmarshallerContext unmarshallerContext) {
        return parseAndConvert(node.getTextContent());
    }

    @Override
    public ParseResult<Object> parseJsonNode(BenderJsonNode json, UnmarshallerContext unmarshallerContext) {
        return json.isNumber()
                ? ParseResult.<Object>result(fromSeconds(json.getNumberValueOrNull().longValue()))
                : parseAndConvert(json.getValueAsString());
    }
}
